# TRAE - AI 学习英雄小程序实战

这是一个学习英雄微信小程序项目，通过游戏化的方式帮助用户学习任何主题。用户输入想学的主题，AI 自动生成相关的知识问答卡片，通过做选择题的方式学习。

这是一个纯 Vibe Coding 项目，主要讲解如何使用 TRAE AI 编程工具快速开发微信小程序。通过自然语言描述需求，让 AI 自动生成包含完整前端和后端的小程序代码、并且利用 TRAE 集成数据库和支付等服务。适合想学习 AI 开发小程序、学习 TRAE 工具的同学。



---



大家好，我是程序员鱼皮。朋友们有没有这样的经历：想学点新技术，打开文档就头疼，刷视频又容易走神，买了一堆课程却总是半途而废。。。

反正我是经常这样，学习焦虑症晚期患者了。

![](https://pic.yupi.icu/1/image-20250928214315214.png)

作为一名程序员，我早就想做个程序来治好自己的学习焦虑症，却因为觉得麻烦一直拖延。直到现在 AI 编程能力足够强大，我才终于出手了！通过 TRAE 只用了 1 天就完成了这个《学习英雄》小程序，让学习像玩游戏一样轻松有趣~

![](https://pic.yupi.icu/1/%E5%B0%8F%E7%A8%8B%E5%BA%8F%E6%BC%94%E7%A4%BA%E6%8B%BC%E5%9B%BE.png)

下面我先带大家体验一下这个小程序，然后会分享整个开发过程中用到的工具和技巧，依然是 **AI 项目开发的保姆级教程**。

点个收藏，我们开始吧！

> 推荐观看视频版：https://bilibili.com/video/BV1yMn3zuE7L



## 项目体验

打开小程序，可以看到界面非常简洁、有活力。点击开始学习，然后输入你想学习的任何主题，比如 Java 基础。

![](https://pic.yupi.icu/1/image-20250928215038368.png)

AI 会根据主题自动生成相关的知识问答卡片。

![](https://pic.yupi.icu/1/image-20250928215106136.png)

然后你只需要点点点做选择题，不用担心做错，因为每道题目都会有解释，哪怕你之前完全没听说过这个主题，一样可以让你学下去。

![](https://pic.yupi.icu/1/image-20250928215137518.png)

除了技术知识外，你还可以尝试更多主题，比如一个词汇、一部电影、甚至是一个人。

![](https://pic.yupi.icu/1/%E5%A4%9A%E7%AD%94%E9%A2%98%E6%8B%BC%E5%9B%BE.png)

原本枯燥的概念通过问答的形式变得生动有趣，学习焦虑瞬间消失了~

你还可以查看自己的学习记录，重新学习或者查看题解。

![](https://pic.yupi.icu/1/%E5%AD%A6%E4%B9%A0%E5%8E%86%E5%8F%B2%E6%8B%BC%E5%9B%BE.png)

没事儿刷一刷，你就能成为学习英雄！



## 开发实现

如果是以前，这种小程序可能要做个好几天。

但现在利用 TRAE IDE 的 AI 编程，我要带大家 **不写一行代码**，把这个小程序做出来。

步骤：

1. 准备开发工具
2. 需求分析
3. 方案设计
4. 服务集成
5. 后端开发
6. 前端开发
7. 测试验证
8. 持续优化



### 1、准备开发工具

既然要用 AI 开发，工具选择很重要。这次我使用的 AI 编程工具是 [TRAE](https://www.trae.ai/)，因为最近它的 SOLO 模式实在太火爆了，我也想试一试。

区别于传统的人类主导 + AI 辅助编程，所谓 SOLO 模式，是让 **AI 主导任务并自动执行开发**，你只需要有一个想法，然后配合 AI 就能让想法真正落地。

![](https://pic.yupi.icu/1/image-20250928220322788.png)

此外，既然要开发前端项目，肯定少不了 [Node.js 环境](https://nodejs.org/zh-cn/download)；既然要开发微信小程序，肯定少不了 [微信开发者工具](https://developers.weixin.qq.com/miniprogram/dev/devtools/download.html)，直接去对应的官网下载安装就好。

![](https://pic.yupi.icu/1/%E4%B8%8B%E8%BD%BD%E5%B7%A5%E5%85%B7%E6%8B%BC%E5%9B%BE.png)



### 2、需求分析

准备好工具后，进入 Trae 的 SOLO 模式，打开比我脸都干净的项目文件夹。

![](https://pic.yupi.icu/1/image-20250928220647365.png)

首先我们要进行需求分析。

别想的太复杂，只需要把自己的想法用自然语言告诉 AI 就好。

比如我给 AI 提了这样的需求：

```markdown
你是一位专业的程序员，请帮我开发《学习英雄 - AI 问答引导式学习》微信小程序。

用户可以自主设置一个想学习（或测验）的主题，由 AI 围绕主题生成若干个有趣的知识问答卡片，通过闯关答题的形式引导用户更轻松愉快地掌握知识。
```

![](https://pic.yupi.icu/1/image-20250928221154635.png)

AI 很快生成了详细的产品需求文档和技术架构文档，很符合企业规范的开发流程。

![](https://pic.yupi.icu/1/image-20250928221128338.png)

看得出来 AI 已经有些迫不及待想写代码了，但是千万别急，一定要先 **仔细确认需求文档**。

AI 写的还是不错的，但不一定完全符合我们的预期。因此我们要人工重点关注要实现的核心功能，移除掉不需要的附加功能，先确保核心业务流程（P0 级需求）跑通。

![](https://pic.yupi.icu/1/image-20250928221334652.png)

**不要嫌这一步麻烦，现在多花 1 分钟，以后节约 1 小时！**

一定要明确需求，防止 AI 做了不该做的功能。

这里有个小技巧，可以利用 TRAE 集成的 Figma 设计工具，在这里获取到一些免费的产品 UI 原型图。

![](https://pic.yupi.icu/1/image-20250928221519374.png)

可以点击查看某个原型具体的设计，只需要选中你看上的原型图，点击添加到对话，TRAE 就会自动把原型图关联到发给 AI 的对话中，这个跨产品之间的交互我觉得还是蛮帅的（不过跟我学做项目的同学应该知道实现原理嘿嘿）。

![](https://pic.yupi.icu/1/image-20250928221618668.png)

不过生活需要惊喜，这里我就让 AI 自己发挥，看看会出现什么创意~



### 3、方案设计

下面我们要进行方案设计，这以前是月薪几万的架构师干的活，现在让小 AI 帮我们 SOLO。

编写这段 Prompt 时一定要注意几个细节，**遵循最小化开发原则**，防止 AI 把简单的事情搞复杂。

```markdown
我已经人工调整了产品需求文档，移除了很多不必要的功能。请你根据我人工修改过的需求，重新生成技术架构文档。要求：
1. 禁止增加需求文档中没有提到的功能
2. 遵循最小化开发原则，以实现功能为主，禁止提供实现功能之外的扩展，比如部署、监控、限流等
3. 遵循前后端分离原则
```

很快 AI 生成了完整的技术架构文档，包括用什么前端和后端技术、接口怎么设计、数据表怎么设计等等。

![](https://pic.yupi.icu/1/image-20250928221924096.png)

这里我建议能看懂文档的同学还是多发挥一些专业性，明确具体的技术选型，让 AI 生成的代码在自己的可控范围内。比如我明确项目使用 Supabase 数据库、使用 OpenRouter 对接 Gemini 大模型提供 AI 服务。

![](https://pic.yupi.icu/1/image-20250928221952548.png)

啥啥啥？这些都是啥？

别担心，等会儿就会讲。

![](https://pic.yupi.icu/1/image-20250928222144713.png)

看不懂文档的同学也不用担心，你就把自己想象成老板或者产品经理，程序员同事吭哧吭哧拿了份技术方案给你，你就说 “怎么实现我不管，这个需求明天上线！” 让他放手干就完了。

你要相信 AI，相信相信的力量~



### 4、服务集成

完成了方案设计，在正式进入开发前，我们还要准备项目依赖的服务。

把用户数据存储在哪里？怎么让程序对接 AI 大模型？

这都是我们要解决的问题。

相比于自己手动安装服务，可以直接使用 TRAE 提供的集成能力，不用专门去看官方文档对接服务，直接傻瓜式安装。

我们重点集成 2 个服务。

![](https://pic.yupi.icu/1/image-20250928222329915.png)



#### 集成 Supabase

[Supabase](https://supabase.com/) 是开源的后端即服务（BaaS）平台，提供数据库存储、用户身份验证、即时 API 等功能，可以帮助开发者快速构建和管理程序后端。

![](https://pic.yupi.icu/1/image-20250928222457606.png)

点击连接按钮，在弹出的页面中完成创建 Supabase 账号、创建组织、以及认证授权。

![](https://pic.yupi.icu/1/image-20250928222520491.png)

然后进入到 TRAE，看到组织成功显示后，点击创建一个新项目，填写一些项目配置信息，然后点击创建。

![](https://pic.yupi.icu/1/image-20250928222545479.png)

创建项目后回到 TRAE 刷新一下，点击连接就可以了，就这么简单~

![](https://pic.yupi.icu/1/image-20250928222608471.png)

如果说之前 AI Vibe Coding 让后端开发者爽翻了，那这波可以说是前端开发者赢麻了，简单的项目都不用自己搭建后端了~



#### 集成 OpenRouter AI 服务

TRAE 能够和多种 AI 服务集成，这里我选择 [OpenRouter](https://openrouter.ai/)，它的优点是可以通过统一的 API 对接各家大模型，比如 Gemini、GPT、Claude 等等。

![](https://pic.yupi.icu/1/image-20250928222649319.png)

首先到官网注册登录账号，然后进入 API Keys 页面创建一个调用 AI 的密钥，然后在 TRAE 中配置并填写密钥，AI 服务就已经集成完毕了。

![](https://pic.yupi.icu/1/image-20250928222833273.png)

但是注意，要确保你有足够的用量，否则可能调用失败，或者报错调用频率太频繁。

![](https://pic.yupi.icu/1/image-20250928222853247.png)



#### 集成 Stripe 支付服务

此外，你还可以集成 [Stripe 支付服务](https://docs.stripe.com/)，它可以让你用最少的代码给产品添加支付和订阅功能。

![](https://pic.yupi.icu/1/image-20250928223013523.png)

只需要先到官网注册账号，它会自动给你提供一个沙盒测试环境、以及对应的 API 密钥，你可以创建自己的产品并设置定价。

![](https://pic.yupi.icu/1/image-20250928223151134.png)

然后把这些信息填写到 TRAE 配置中，之后 AI 编程时就会生成支付相关的代码了。

![](https://pic.yupi.icu/1/image-20250928223346093.png)

但是由于微信小程序有一些限制，这里我就先不接入了，大家了解一下就好，网页端和 APP 产品接入还是很香的。



### 5、后端开发

准备工作完成后，我们终于要进入紧张刺激的开发环节了。

这里要注意，由于 **AI 的上下文是有限的**，为了能更好地生成完整项目、减少 Bug，建议分个步骤：先生成后端代码，人工校验通过后，再生成前端代码。

好，给 AI 输入提示词，先开发后端，确保项目可以正常运行：

```markdown
请你基于最新的产品需求文档和技术架构文档进行开发，优先开发后端，确保项目可以正常运行
```

我们可以使用 TRAE 提供的 Prompt 优化功能来一键优化提示词。

![](https://pic.yupi.icu/1/%E4%BC%98%E5%8C%96%E6%8F%90%E7%A4%BA%E8%AF%8D.png)

嗯，确实比之前更严谨了。

点击执行，请开始你的 SOLO~ AI 会先给出任务计划：

![](https://pic.yupi.icu/1/image-20250928224232897.png)

然后自主操作终端执行命令、编写后端配置文件和业务逻辑代码、编写数据库建表语句等等，重要操作还会找我们主动确认，非常严谨。

![](https://pic.yupi.icu/1/image-20250928224300188.png)

看不懂也没关系，让他放手干吧~

等待期间，你可以到编程导航上看看 [免费的编程学习路线](https://codefather.cn/)。TRAE 自带消息通知功能，AI 完成任务后会提醒我们。

我感觉 TRAE 调教 AI 还是有一套的，他会自己验证程序是否正常。不过由于我们还没有填写微信登录所需的信息，接口无法完整调用是正常的。

![](https://pic.yupi.icu/1/image-20250928224350332.png)

一段时间后，AI 生成完毕，不仅生成了代码，还很贴心地生成了后端的接口文档。

![](https://pic.yupi.icu/1/image-20250928224437599.png)

哎，这个东西很有用哦。



### 6、前端开发

下面进行前端开发。

这里一定要注意，不要接着之前的对话继续写提示词了。

为什么呢？

因为 AI 大模型的上下文是有限的，前面的操作已经消耗了不少上下文，为了防止 AI 上下文不足或者记忆混乱，我们生成前端时，重新开一个干净的对话来编写提示词。

![](https://pic.yupi.icu/1/image-20250928224735250.png)

提示词中提供给 AI 产品需求文档、技术架构文档和后端接口文档，就可以让 AI 专注于前端代码生成。

```markdown
你是一位专业的程序员，请帮我开发《学习英雄 - AI 问答引导式学习》微信小程序。

用户可以自主设置一个想学习（或测验）的主题，由 AI 围绕主题生成若干个有趣的知识问答卡片，通过闯关答题的形式引导用户更轻松愉快地掌握知识。

请你根据 @产品需求文档 @技术架构文档 @后端接口文档，帮我生成完整可运行的微信小程序前端代码。
注意：
1. 遵循最小功能原则，不要额外开发需求文档没提到的任何功能
2. 如果需要显示图片，请使用占位图片 picsum.photos 代替（比如 picsum.photos/200/300）
```

好，执行！

等待期间，你可以到 [面试鸭](https://www.mianshiya.com/) 上看看免费的面试题和刷题路线。

一段时间后，AI 生成完毕，一次性 SOLO 出了 20 多个文件！

![](https://pic.yupi.icu/1/image-20250928224830751.png)

虽然看着很爽，但老实说我是有点慌的，不知道能不能正常运行。



### 7、测试验证

下面我们来到了激动人心的测试验证环节。

首先需要打开微信开发者工具，导入已有项目文件夹，先选择使用测试号开发调试项目。

![](https://pic.yupi.icu/1/image-20250928225118198.png)

打开项目后，我们先点击右上角的 “测试号”，按照 [文档](https://developers.weixin.qq.com/miniprogram/dev/devtools/sandbox.html) 的指引获取到测试号的 AppID 和 AppSecret 密钥：

![](https://pic.yupi.icu/1/image-20250928225220066.png)

然后手动填入到后端配置文件中，否则将无法正常微信登录。

![](https://pic.yupi.icu/1/image-20250928225304614.png)

然后我们就可以编译运行项目了。

结果，果然报错了！

![](https://pic.yupi.icu/1/image-20250928225522618.png)

意料之中，意料之中。。。小程序开发比网页开发还是更难一些的，毕竟微信开发者工具和文档一直在更新。

![](https://pic.yupi.icu/1/image-20250928225618743.png)

不过没关系，开发过程中难免遇到问题，解决方法很简单，一句话：**报什么错误，就把报错信息发给 AI，让 AI 来修复！**

像我这里遇到了几个典型的问题：

1）图片路径问题：利用 TRAE 的提示词优化功能，能更好地指引 AI 按照指定的步骤修复 Bug

![](https://pic.yupi.icu/1/image-20250928225717687.png)

2）登录失败问题：点击开发者工具右上角的 “详情”，进入到本地设置中，勾选 “不校验合法域名”

![](https://pic.yupi.icu/1/image-20250928225825654.png)

3）接口路径问题：这可能是由于上下文过长导致的，让 AI 整体修复前端调用后端接口的路径和参数就好

![](https://pic.yupi.icu/1/image-20250928225903118.png)

4）环境配置问题：代码中读取的环境变量名称和配置文件中的不一致，这个问题比较简单，我们可以手动修改。

当我敲了一个字符后，编辑器会自动提示我要修改哪些代码，还支持跨行修改。

![](https://pic.yupi.icu/1/image-20250928225955681.png)

这是 TRAE 提供的 CUE 功能，不仅可以帮你自动补全代码、还可以多行修改代码、自动预测未来可能的修改点，尤其适合重构代码的场景，效率起飞。

![](https://pic.yupi.icu/1/%E5%A4%9A%E8%A1%8C%E4%BF%AE%E6%94%B9.gif)

经过一段时间的修复，我们的小程序已经可以正常运行了。虽然现在页面丑丑的，但只要跑通了核心业务流程，用户能正常使用，后续的优化都很简单了。

![](https://pic.yupi.icu/1/image-20250928230045861.png)



### 8、持续优化

最后，如果你要把小程序上线，还是要花一些时间来优化的。

记住，优化前先把现有代码利用 Git 版本控制工具进行托管，并且提交一个基础版本，这样之后优化出了任何问题，都可以一键回滚到老版本。

![](https://pic.yupi.icu/1/image-20250928230154447.png)

像我重点让 AI 帮忙优化了整个小程序的样式风格，只要写一段简单的提示词：

```markdown
你是一位程序员，请你帮我优化整个小程序中每个前端页面和元素的样式风格，使各个页面保持一致。

参考风格：主色调采用活力橙色，清新治愈的卡通风格、简约雅致、让人感到放松愉快。
```

然后利用 TRAE 的提示词优化功能，就能得到一个更详细的优化方案。

![](https://pic.yupi.icu/1/image-20250928230225960.png)

你可以按需调整，也可以让 AI 放手干。

建议大家每进行一次优化或新增一个功能，都提交一次代码，并且适当地新开 AI 对话框，防止上下文过多影响生成的准确度。

最终，你看到的这个小程序，就是我优化后的成品啦，效果还不错吧~

![](https://pic.yupi.icu/1/image-20250928230316272.png)

但由于卡在认证备案的流程上了（已经在备案中了），要过段时间大家才能体验到小程序啦。

![](https://pic.yupi.icu/1/%E5%A4%87%E6%A1%88.png)



## 总结

最后聊聊我使用 TRAE SOLO 开发项目的感受吧。

首先我感受到了 AI 编程工具的进化，SOLO 从 **将 AI 集成到工具中，进化为将开发工具集成到 AI 中**。

![](https://pic.yupi.icu/1/image-20250928220158367.png)

感觉开发工具只是 AI 的一个玩物，他可以自由地操作编辑器、终端、浏览器、文档、集成服务等等来自主完成任务，确实比以前更高效智能了，也能完成包含后端的完整项目。而且 AI 会遵循企业标准的开发流程，自动修复大部分问题、检查项目能否运行，不像以前很多时候生成的代码是运行不了的。

但是开发过程中大家要注意，现在 **AI 很喜欢把简单的事情搞复杂**，所以最好人工仔细确认需求文档和方案文档，并且像搭积木一样，一步一步地完成开发。

后面我也会给大家分享更多 AI 编程的技巧，毕竟 AI 是个工具，只有用对了，才能发挥他最大价值。



## 推荐资源

1）鱼皮 AI 导航网站：[AI 资源大全、最新 AI 资讯、免费 AI 教程](https://ai.codefather.cn)

2）编程导航学习圈：[学习路线、编程教程、实战项目、求职宝典、交流答疑](https://www.codefather.cn)

3）程序员面试八股文：[实习/校招/社招高频考点、企业真题解析](https://www.mianshiya.com)

4）程序员写简历神器：[专业模板、丰富例句、直通面试](https://www.laoyujianli.com)

5）1 对 1 模拟面试：[实习/校招/社招面试拿 Offer 必备](https://ai.mianshiya.com)
